#include 	"MDSFxx_SFR.h"
#include 	"XSFR_GLOBAL.h"
#include 	"Allhex.h"

#define 	EEPDefaultStatus 	0x0
#define 	EEPWriteStatus 		0x1
#define 	EEPRaedStatus 		0x2
#define 	EEPEraseStatus 		0x3


uint8 	EEP_First_add = 0x00;
uint8 	EEP_First_data = 20;

uint8 	EEPBuf;
// uint8 	EEPStatus;
uint8 	EEPStep = 0;
xdata 	uint8 	eprom_data;

//********************************************************************************
//							 EEPROM Power Init Read Data
//********************************************************************************
#if (EEPROM_MODE==1)
void EEP_Power_Init_read_data(void){
		eprom_data = 	EEP_Read(0x00);	//?t??q??.

		if(eprom_data!=0xFF){
			#if (RF_Control == 1)
				RF_Learning_Address[0] = EEP_Read(0x01);	//RF Address1.
				RF_Learning_Address[1] = EEP_Read(0x02);	//RF Address2.
				RF_Learning_Address[2] = EEP_Read(0x03);	//RF Address3.
			#endif
			//eprom_data = 0;
			FLAG.Smart_Function_eeprom = EEP_Read(0x04);	
			FLAG.Smart_Function_sw = FLAG.Smart_Function_eeprom;
		}
		else{
			eprom_data = 0;
			#if (Default_State == 1)
				FLAG.MOTOR_PWM_ENABLE = 1;
				eprom_data = SpeedNum_Default;
			#endif
			
			#if (RF_Control == 1)
				RF_Learning_Address[0] = 0;
				RF_Learning_Address[1] = 0;
				RF_Learning_Address[2] = 0;
			#endif
			FLAG.Smart_Function_eeprom = 0;
		}
//********************************************************************************
//To add EEROM read data, enter here
//********************************************************************************
	if(eprom_data!=0)
		FLAG.MOTOR_PWM_ENABLE = 1;
	SpeedNum = eprom_data;
	
	#if (CURRENT_CONTROL == 1)
		if(eprom_data==1){
			CurrentCmd = IR_Current_1_VALUE;
			FLAG.MOTOR_PWM_ENABLE = 1;
		}
		else if(eprom_data==2){
			CurrentCmd = IR_Current_2_VALUE;
			FLAG.MOTOR_PWM_ENABLE = 1;
		}
		else if(eprom_data==3){
			CurrentCmd = IR_Current_3_VALUE;
			FLAG.MOTOR_PWM_ENABLE = 1;
		}
		else if(eprom_data==4){
			CurrentCmd = IR_Current_4_VALUE;
			FLAG.MOTOR_PWM_ENABLE = 1;
		}
		else if(eprom_data==5){
			CurrentCmd = IR_Current_5_VALUE;
			FLAG.MOTOR_PWM_ENABLE = 1;
		}
		// SpeedNum = eprom_data;
		// SpeedNum_temp = SpeedNum;
	#endif
}
#endif
//********************************************************************************
//								  EEPROM INIT
//********************************************************************************
// void EEP_Init(void){
	
	// EEP_First_data = EEP_First_add + EEP_num;

	// if(EEP_Read(Add) == 0xFF){
		// EEP_Erase();
		// EEP_Write(Add,10);
	// }
	// else if(EEP_Read(Add) == 0x00){
		// EEP_Erase();
		// EEP_Write(Add,100);
	// }
	// else{
		// EEPBuf = EEP_Read(Add);
		// EEPBuf += 5;
		// EEPBuf &= 0xFF;
		// EEP_Erase();
		// EEP_Write(Add,EEPBuf);
	// }
// }
//********************************************************************************
//							  	 EEPROM SAVING
//********************************************************************************
/*void EEP_Saving(uint8 rf_data){	
	if(EEPStep<20){		
		EEPBuf = EEP_Read(EEP_First_add);				//0000 0000
		if(EEPBuf!=0x00)
			EEP_Write(EEP_First_add,EEPBuf>>1);			//0011 1111
		else{
			EEPStep+=1;
			EEP_First_add+=1;
			EEPBuf = EEP_Read(EEP_First_add);
			EEP_Write(EEP_First_add,EEPBuf>>1);
		}
	}
	else{
		EEP_Erase();
		EEPStep = 0;
		EEP_First_add = 0;
		EEP_First_data = 20;
		EEPBuf = EEP_Read(EEP_First_add);
		EEP_Write(EEP_First_add,EEPBuf>>1);
	}
	EEPStatus = EEP_First_data;						//EEPBuf = 1
	EEP_First_data+=1;
	
	EEP_Write(0xFE,EEPStatus);
	EEP_Write(EEPStatus,rf_data);
}*/
//********************************************************************************
//								  EEPROM ERASE
//********************************************************************************
void EEP_Erase (void){
	// uint8 Temp;
	
	SFR_PAGE = 2;
	EEPROM |= EepErase;	//0x08
	
	// do{
		// SFR_PAGE = 2;
		// Temp = EEPROM;
	// }
	// while((Temp & EepEraseFlag) == EepEraseFlag);	// Wait Erase done, ERS_FLAG = 0
}
//********************************************************************************
//								  EEPROM WRITE
//********************************************************************************
void EEP_Write (uint8 Add,uint8 Data){
	uint8 Temp;
	
	SFR_PAGE = 0;
	EEPROM = Add;
	SFR_PAGE = 1;
	EEPROM = Data;
	SFR_PAGE = 2;
	EEPROM = EepWrite;
	
	do{
		SFR_PAGE = 2;
		Temp = EEPROM;
	}
	while((Temp & EepWriteFlag) == EepWriteFlag);
}
//********************************************************************************
//								   EEPROM READ
//********************************************************************************
#if (EEPROM_MODE==1)
uint8 EEP_Read (uint8 Add){
	uint8 Temp;
	
	SFR_PAGE = 0;
	EEPROM = Add;
	SFR_PAGE = 2;
	EEPROM = EepRead;
	
	do{
		SFR_PAGE = 2;
		Temp = EEPROM;
	}
	while((Temp & EepReadFlag) == EepReadFlag);
	
	SFR_PAGE = 1;
	Temp = EEPROM;
	return Temp;
}
#endif